<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Logo\logo;
use App\Http\Requests\LogoRequest;
use Illuminate\Support\Facades\Storage;

class LogoController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = logo::all();
        return view('admin.data.customers.logos', compact('data'));
    }

    public function form()
    {
        return view('admin.form.logo.logos');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(LogoRequest $request)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "logo_customer";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = logo::create(
                    [
                        'img_name' => $path,
                        'company_name' => $request->company_name
                    ]
                );
                if ($data) {
                    return back()->with('success', 'เพิ่มข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else {
            return back()->with('error', 'อัพโหลดไม่สำเร็จ');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = logo::find($id);
        return view('admin.form_edit.logo.logos', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(LogoRequest $request, $id)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "logo_customer";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = logo::where('id', $id)->update(['img_name' => $path, 'company_name' => $request->company_name]);
                if ($data) {
                    return redirect('/admin/logo')->with('success', 'แก้ไขข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else if (!$request->hasFile('files')) {
            $data = logo::where('id', $id)->update(['company_name' => $request->company_name]);
            if ($data) {
                return redirect('/admin/logo')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = logo::where('id', $id)->delete($id);
        if ($data) {
            return redirect('admin/logo')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
