<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SlideRequest extends FormRequest
{
    protected $rules = [
        
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'files.required' => 'กรุณาใส่ภาพสไลด์',
            'slide_status.required' => 'กรุณาเลือกออฟชันก์'
        ];
    }

    private function postproduct()
    {
        $rules = $this->rules;
        $rules['files'] = 'required';
        return $rules;
    }

    private function putproduct()
    {
        $rules = $this->rules;
        $rules['slide_status'] = 'required';
        return $rules;
    }
}
