<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UsersRequest extends FormRequest
{
    protected $rules = [
        'username'   => 'required|max:255',
        'firstname' => 'required',
        'lastname' => 'required'
    ];

    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST':
                return $this->postproduct();
            case 'PUT':
                return $this->putproduct();
            default:
                return $this->rules;
        }
    }

    public function messages()
    {
        return [
            'username.required' => 'กรุณาระบุไอดี',
            'password.required' => 'กรุณาระบุพาสเวิร์ดอย่างน้อย 8 ตัวขึ้นไป',
            'firstname.required' => 'กรุณาระบุชื่อ',
            'lastname.required' => 'กรุณาระบุนามสกุล'
        ];
    }

    private function postproduct()
    {
        $rules =  $this->rules;
        $rules['password'] = 'required|min:8';
        return $rules;
    }

    private function putproduct()
    {
        return $this->rules;
    }
}
