@inject('menu', 'App\Models\Other\Other')
@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card">
                <div class="card-header">
                    <strong>
                        <h3 class="card-title">รายการสินค้าทั้งหมด</h3>
                    </strong>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th class="text-center text-nowrap">#</th>
                                <th class="text-center text-nowrap">ชื่อสินค้า</th>
                                <th class="text-center text-nowrap">ราคา</th>
                                <th class="text-center text-nowrap">หมวดหมู่</th>
                                <th class="text-center text-nowrap">คุณลักษณะ</th>
                                <th class="text-center text-nowrap">คุณสมบัติ</th>
                                <th class="text-center text-nowrap">รูปภาพ</th>
                                <th class="text-center text-nowrap">ดำเนินการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $key => $rows)
                                <tr>
                                    <td class="text-center">{{ ++$key }}</td>
                                    <td>{{ $rows->products_name }}</td>
                                    <td class="text-center">{{ $rows->products_price }}</td>
                                    <td class="text-center">
                                        @php
                                            $datamenu = $menu->productmenu();
                                        @endphp
                                        @foreach ($datamenu as $rows2)
                                            @if ($rows2->id == $rows->products_categorys)
                                                {{ $rows2->categorys_names }}
                                            @endif
                                        @endforeach
                                    </td>
                                    <td>{{ $rows->products_attribute ?  $rows->products_attribute : '-'}}</td>
                                    <td><pre>{{ $rows->products_detail }}</pre></td>
                                    <td class="text-center">
                                        <img src="{{ asset('' . $rows->products_img . '') }}" class="img-fluid"
                                            alt="{{ $rows->products_name }}" width="200" height="200">
                                    </td>
                                    <td class="text-center">
                                        <form action="{{ route('products.destroy', $rows->id) }}" method="POST">
                                            @csrf

                                            <a class="btn btn-info btn-sm"
                                                href="{{ route('products.edit', $rows->id) }}">
                                                <i class="fas fa-pencil-alt">
                                                </i>
                                            </a>
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                onclick="return confirm('ต้องการลบรายการนี้หรือไม่')">
                                                <i class="fas fa-trash">
                                                </i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="card-footer text-center">
                        <a href="{{ asset('/admin/productsform') }}">เพิ่มข้อมูลสินค้า</a>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')
    <script src="{{ asset('template2') }}/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="{{ asset('template2') }}/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="{{ asset('template2') }}/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="{{ asset('template2') }}/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="{{ asset('template2') }}/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="{{ asset('template2') }}/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script>
        $(function() {
            $('#example1').DataTable({});
        });
    </script>
@endsection
