@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">แก้ไขข้อมูลลูกค้า</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('logo.update',''.$data->id.'') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">ชื่อบริษัท <small class="text-danger">*</small></label>
                            <input type="text" name="company_name" class="form-control" id="company_name"
                                placeholder="ชื่อบริษัท" value="{{ $data->company_name }}">
                            <small class="text-danger">{{ $errors->first('company_name') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">รูปภาพ <small class="text-danger">*</small></label>
                            <input class="form-control" type="file" id="files" name="files">
                            <small class="text-danger">{{ $errors->first('files') }}</small>
                            <br/>
                            <label for="exampleInputEmail1">รูปภาพเดิม <small class="text-danger">*</small></label>
                            <img src="{{ asset('' . $data->img_name . '') }}" alt="{{ $data->company_name }}" class="img-fluid">
                            <span id="imgshow"></span>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        <a href="{{ asset('admin/logo') }}"><button type="button"
                            class="btn btn-danger">ยกเลิก</button></a>
                        <button type="submit" class="btn btn-warning">แก้ไขข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')
    <script>
        $('document').ready(function() {
            $("#files").change(function() {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $("#imgshow").html('<img src="' + e.target.result + '" align="left">')
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    </script>
@endsection
