@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">แก้ไขข้อมูลข่าวสาร</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('news.update',''.$data->id.'') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">หัวข้อข่าวสาร <small class="text-danger">*</small></label>
                            <input type="text" name="news_toppics" class="form-control" id="news_toppics" placeholder="หัวข้อข่าวสาร"
                                value="{{ $data->news_toppics }}">
                            <small class="text-danger">{{ $errors->first('news_toppics') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">เนื้อหา <small class="text-danger">*</small></label>
                            <textarea class="form-control" name="news_bodys" id="news_bodys" cols="30" rows="10">{{ $data->news_bodys }}</textarea>
                            <small class="text-danger">{{ $errors->first('news_bodys') }}</small>
                        </div>                                                                       
                        <div class="form-group">
                            <label for="exampleInputEmail1">รูปภาพข่าวสาร <small class="text-danger">*</small></label>
                            <input class="form-control" type="file" id="files" name="files">
                            <small class="text-danger">{{ $errors->first('files') }}</small>
                            <br />
                            <label for="exampleInputEmail1">รูปภาพเดิม </label><br/>
                            <img src="{{ asset('' . $data->news_img . '') }}" alt="{{ $data->news_toppics }}" class="img-fluid">
                            <span id="imgshow"></span>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="{{ asset('admin/news') }}"><button type="button"
                            class="btn btn-danger">ยกเลิก</button></a>
                        <button type="submit" class="btn btn-warning">แก้ไขข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')    
<script>
    $('document').ready(function() {
        $("#files").change(function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $("#imgshow").html('<img src="'+e.target.result+'" align="left">')
                }
                reader.readAsDataURL(this.files[0]);
            }
        });
    });
</script>
@endsection
