@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">แก้ไขข้อมูล</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('user.update', $data->username) }}" method="post">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Username</label>
                            <input type="text" name="username" class="form-control" id="username" placeholder="Username"
                                value="{{ $data->username }}">
                            <small class="text-danger">{{ $errors->first('username') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputPassword1">Password</label>
                            <input type="password" name="password" id="password" class="form-control" id="password"
                                placeholder="Password">
                            <small class="text-danger">{{ $errors->first('password') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ชื่อ</label>
                            <input type="text" name="firstname" class="form-control" id="firstname" placeholder="Firstname"
                                value="{{ $data->firstname }}">
                            <small class="text-danger">{{ $errors->first('firstname') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">นามสกุล</label>
                            <input type="text" name="lastname" class="form-control" id="lastname" placeholder="Lastname"
                                value="{{ $data->lastname }}">
                            <small class="text-danger">{{ $errors->first('lastname') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="role">สิทธิ์การใช้งาน</label>
                            <select class="custom-select" name="role" id="role">
                                <option value="1" {{ $data->role == 1 ? 'selected' : '' }}>ผู้ใช้งานทั่วไป</option>
                                <option value="2" {{ $data->role == 2 ? 'selected' : '' }}>ผู้ดูแลระบบ</option>
                            </select>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="{{ asset('admin/user') }}"><button type="button"
                            class="btn btn-danger">ยกเลิก</button></a>
                        <button type="submit" class="btn btn-warning">แก้ไขข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
        <!-- right column -->

        <!--/.col (right) -->
    </div>
@endsection
